<?php
/* ===================== suppliers.php (Enhanced & Mobile-Friendly Version) ===================== */
session_start();
include 'db.php';
include 'header.php';

// Handle Add Supplier
if(isset($_POST['add'])){
    $name = $_POST['name'];
    $phone = $_POST['phone'];
    $email = $_POST['email'];
    $address = $_POST['address'];

    $stmt = $conn->prepare("INSERT INTO suppliers (name, phone, email, address) VALUES (?, ?, ?, ?)");
    $stmt->bind_param("ssss", $name, $phone, $email, $address);
    $stmt->execute();
    header("Location: suppliers.php");
    exit;
}

// Handle Delete Supplier
if(isset($_GET['delete'])){
    $id = $_GET['delete'];
    $stmt = $conn->prepare("DELETE FROM suppliers WHERE id = ?");
    $stmt->bind_param("i", $id);
    $stmt->execute();
    header("Location: suppliers.php");
    exit;
}

// Handle Search
$search = isset($_GET['search']) ? $_GET['search'] : '';
$search_sql = $conn->real_escape_string($search);

// Pagination settings
$limit = 10;
$page = isset($_GET['page']) ? (int)$_GET['page'] : 1;
$offset = ($page - 1) * $limit;

// Fetch total count
$total_result = $conn->query("SELECT COUNT(*) as total FROM suppliers WHERE name LIKE '%$search_sql%' OR phone LIKE '%$search_sql%' OR email LIKE '%$search_sql%' OR address LIKE '%$search_sql%'");
$total_row = $total_result->fetch_assoc();
$total = $total_row['total'];
$total_pages = ceil($total / $limit);

// Fetch suppliers with search & pagination
$result = $conn->query("SELECT * FROM suppliers WHERE name LIKE '%$search_sql%' OR phone LIKE '%$search_sql%' OR email LIKE '%$search_sql%' OR address LIKE '%$search_sql%' ORDER BY name ASC LIMIT $offset, $limit");
?>

<div class="container mt-4">
    <h3 class="mb-3">Suppliers</h3>

    <!-- Search Form -->
    <form method="GET" class="row g-3 mb-3">
        <div class="col-md-6">
            <input type="text" name="search" class="form-control" placeholder="Search by name, phone, email or address" value="<?= htmlspecialchars($search) ?>">
        </div>
        <div class="col-md-2">
            <button class="btn btn-primary w-100">Search</button>
        </div>
    </form>

    <!-- Add Supplier Form -->
    <form method="POST" class="row g-3 mb-4">
        <div class="col-md-3"><input name="name" class="form-control" placeholder="Supplier Name" required></div>
        <div class="col-md-3"><input name="phone" class="form-control" placeholder="Phone" required></div>
        <div class="col-md-3"><input name="email" class="form-control" placeholder="Email"></div>
        <div class="col-md-3"><input name="address" class="form-control" placeholder="Address"></div>
        <div class="col-md-2"><button name="add" class="btn btn-success w-100">Add Supplier</button></div>
    </form>

    <!-- Export Buttons -->
    <a href="export_suppliers_excel.php" class="btn btn-success btn-sm mb-2">Export to Excel</a>
    <a href="export_suppliers_pdf.php" class="btn btn-danger btn-sm mb-2">Export to PDF</a>

    <!-- Suppliers Table (responsive) -->
    <div class="table-responsive">
        <table class="table table-bordered">
            <thead class="table-dark">
                <tr>
                    <th>Name</th>
                    <th>Email</th>
                    <th>Address</th>
                    <th>Phone</th>
                    <th>Actions</th>
                </tr>
            </thead>
            <tbody>
            <?php while($row = $result->fetch_assoc()): ?>
                <tr>
                    <td><?= htmlspecialchars($row['name']) ?></td>
                    <td><?= htmlspecialchars($row['email']) ?></td>
                    <td><?= htmlspecialchars($row['address']) ?></td>
                    <td><?= htmlspecialchars($row['phone']) ?></td>
                    <td>
                            <?php if($_SESSION['role'] === 'admin'): ?>
                        <a href="supplier_edit.php?id=<?= $row['id'] ?>" class="btn btn-warning btn-sm">Edit</a>
                        <a href="suppliers.php?delete=<?= $row['id'] ?>&search=<?= urlencode($search) ?>" class="btn btn-danger btn-sm" onclick="return confirm('Delete supplier?')">Delete</a>
                            <?php else: ?>
        <span class="text-muted"><center><i class="fa fa-lock"></i></center>
</span>
    <?php endif; ?>
                    </td>
                </tr>
            <?php endwhile; ?>
            </tbody>
        </table>
    </div>

    <!-- Pagination -->
    <nav>
      <ul class="pagination">
        <?php for($i=1; $i<=$total_pages; $i++): ?>
            <li class="page-item <?= ($i==$page)?'active':'' ?>">
                <a class="page-link" href="?page=<?= $i ?>&search=<?= urlencode($search) ?>"><?= $i ?></a>
            </li>
        <?php endfor; ?>
      </ul>
    </nav>

    <p>Total Suppliers: <?= $total ?></p>
</div>

<?php include 'footer.php'; ?>
