<?php
/* ===================== supplier_edit.php ===================== */
session_start();
include 'db.php';
include 'header.php';

if(!isset($_GET['id'])){
    header('Location: suppliers.php');
    exit;
}

$id = $_GET['id'];

// Fetch supplier data
$stmt = $conn->prepare("SELECT * FROM suppliers WHERE id = ?");
$stmt->bind_param("i", $id);
$stmt->execute();
$result = $stmt->get_result();
$supplier = $result->fetch_assoc();

if(!$supplier){
    echo '<div class="alert alert-danger">Supplier not found.</div>';
    include 'footer.php';
    exit;
}

// Handle update
if(isset($_POST['update'])){
    $name = $_POST['name'];
    $phone = $_POST['phone'];
    $email = $_POST['email'];
    $address = $_POST['address'];

    $stmt = $conn->prepare("UPDATE suppliers SET name=?, phone=?, email=?, address=? WHERE id=?");
    $stmt->bind_param("ssssi", $name, $phone, $email, $address, $id);
    $stmt->execute();
    header('Location: suppliers.php');
    exit;
}
?>

<div class="container mt-4">
    <h3>Edit Supplier</h3>
    <form method="POST" class="row g-3">
        <div class="col-md-6"><input name="name" class="form-control" placeholder="Supplier Name" value="<?= htmlspecialchars($supplier['name']) ?>" required></div>
        <div class="col-md-6"><input name="phone" class="form-control" placeholder="Phone" value="<?= htmlspecialchars($supplier['phone']) ?>"></div>
        <div class="col-md-6"><input name="email" class="form-control" placeholder="Email" value="<?= htmlspecialchars($supplier['email']) ?>"></div>
        <div class="col-md-6"><input name="address" class="form-control" placeholder="Address" value="<?= htmlspecialchars($supplier['address']) ?>"></div>
        <div class="col-md-2"><button name="update" class="btn btn-success w-100">Update</button></div>
    </form>
</div>

<?php include 'footer.php'; ?>
