<?php
/* ===================== sales_report.php (Enhanced) ===================== */
session_start();
include 'db.php';
include 'header.php';

// Default filters
$start_date = $_GET['start_date'] ?? date('Y-m-d');
$end_date = $_GET['end_date'] ?? date('Y-m-d');
$filter_product = $_GET['product_id'] ?? '';
$filter_customer = $_GET['customer_id'] ?? '';
$filter_category = $_GET['expense_category'] ?? '';
$show_type = $_GET['show_type'] ?? 'all'; // sales | expenses | all

/* ===================== Fetch Dropdown Data ===================== */
$products_list = $conn->query("SELECT id, name FROM products ORDER BY name");
$customers_list = $conn->query("SELECT id, name FROM customers ORDER BY name");
$expense_categories = $conn->query("SELECT DISTINCT category FROM expenses ORDER BY category");

/* ===================== Build Dynamic Conditions ===================== */
$sales_condition = "s.sale_date BETWEEN '$start_date' AND '$end_date'";
$expenses_condition = "expense_date BETWEEN '$start_date' AND '$end_date'";

if ($filter_product) $sales_condition .= " AND s.product_id = $filter_product";
if ($filter_customer) $sales_condition .= " AND s.customer_id = $filter_customer";
if ($filter_category) $expenses_condition .= " AND category = '$filter_category'";

/* ===================== Fetch Sales ===================== */
if ($show_type !== 'expenses') {
    $sales = $conn->query("
        SELECT s.*, p.name AS product_name, c.name AS customer_name, p.quantity AS current_stock
        FROM sales s
        LEFT JOIN products p ON s.product_id = p.id
        LEFT JOIN customers c ON s.customer_id = c.id
        WHERE $sales_condition
        ORDER BY s.sale_date ASC
    ");
}

/* ===================== Fetch Expenses ===================== */
if ($show_type !== 'sales') {
    $expenses = $conn->query("
        SELECT * FROM expenses 
        WHERE $expenses_condition
        ORDER BY expense_date ASC
    ");
}

/* ===================== Calculate Totals ===================== */
$total_sales = 0;
$total_expenses = 0;

// Sales totals
if (!empty($sales)) {
    foreach ($sales as $row) {
        $total_sales += $row['total'];
    }
}

// Expenses totals
if (!empty($expenses)) {
    foreach ($expenses as $row) {
        $total_expenses += $row['amount'];
    }
}

$balance = $total_sales - $total_expenses;

?>
<div class="container mt-4">
    <h3 class="mb-3">Sales & Expenses Report</h3>

    <!-- Filters -->
    <form method="GET" class="row g-3 mb-4">

        <div class="col-md-2">
            <label>Start Date</label>
            <input type="date" name="start_date" class="form-control" value="<?= $start_date ?>">
        </div>

        <div class="col-md-2">
            <label>End Date</label>
            <input type="date" name="end_date" class="form-control" value="<?= $end_date ?>">
        </div>

        <div class="col-md-2">
            <label>Product</label>
            <select name="product_id" class="form-control">
                <option value="">All</option>
                <?php while($p = $products_list->fetch_assoc()): ?>
                    <option value="<?= $p['id'] ?>" <?= ($filter_product == $p['id']) ? 'selected':'' ?>>
                        <?= htmlspecialchars($p['name']) ?>
                    </option>
                <?php endwhile; ?>
            </select>
        </div>

        <div class="col-md-2">
            <label>Customer</label>
            <select name="customer_id" class="form-control">
                <option value="">All</option>
                <?php while($c = $customers_list->fetch_assoc()): ?>
                    <option value="<?= $c['id'] ?>" <?= ($filter_customer == $c['id']) ? 'selected':'' ?>>
                        <?= htmlspecialchars($c['name']) ?>
                    </option>
                <?php endwhile; ?>
            </select>
        </div>

        <div class="col-md-2">
            <label>Expense Category</label>
            <select name="expense_category" class="form-control">
                <option value="">All</option>
                <?php while($cat = $expense_categories->fetch_assoc()): ?>
                    <option value="<?= $cat['category'] ?>" <?= ($filter_category == $cat['category']) ? 'selected':'' ?>>
                        <?= htmlspecialchars($cat['category']) ?>
                    </option>
                <?php endwhile; ?>
            </select>
        </div>

        <div class="col-md-2">
            <label>Show</label>
            <select name="show_type" class="form-control">
                <option value="all" <?= ($show_type=='all')?'selected':'' ?>>Sales & Expenses</option>
                <option value="sales" <?= ($show_type=='sales')?'selected':'' ?>>Only Sales</option>
                <option value="expenses" <?= ($show_type=='expenses')?'selected':'' ?>>Only Expenses</option>
            </select>
        </div>

        <div class="col-md-2 pt-4">
            <button class="btn btn-primary w-100">Filter</button>
        </div>
    </form>

    <!-- Summary Cards -->
    <div class="row mb-3">
        <div class="col-md-4">
            <div class="alert alert-success"><strong>Total Sales:</strong> <?= number_format($total_sales,2) ?></div>
        </div>
        <div class="col-md-4">
            <div class="alert alert-danger"><strong>Total Expenses:</strong> <?= number_format($total_expenses,2) ?></div>
        </div>
        <div class="col-md-4">
            <div class="alert alert-info"><strong>Balance:</strong> <?= number_format($balance,2) ?></div>
        </div>
    </div>

    <!-- PRINT BUTTON -->
    <button onclick="window.print()" class="btn btn-secondary mb-3">🖨 Print Report</button>

    <!-- SALES TABLE -->
    <?php if ($show_type !== 'expenses'): ?>
        <h5>Sales Records</h5>
        <div class="table-responsive">
            <table class="table table-bordered table-hover">
                <thead class="table-dark">
                    <tr>
                        <th>Date</th>
                        <th>Product</th>
                        <th>Customer</th>
                        <th>Qty</th>
                        <th>Unit Price</th>
                        <th>Total</th>
                        <th>Stock Status</th>
                    </tr>
                </thead>
                <tbody>
                <?php foreach($sales as $row): ?>
                    <tr>
                        <td><?= $row['sale_date'] ?></td>
                        <td><?= htmlspecialchars($row['product_name']) ?></td>
                        <td><?= htmlspecialchars($row['customer_name'] ?? '-') ?></td>
                        <td><?= $row['quantity'] ?></td>
                        <td><?= number_format($row['unit_price'],2) ?></td>
                        <td><?= number_format($row['total'],2) ?></td>
                        <td>
                            <?php if($row['quantity'] > $row['current_stock']): ?>
                                <span class="badge bg-danger">Low Stock</span>
                            <?php else: ?>
                                <span class="badge bg-success">OK</span>
                            <?php endif; ?>
                        </td>
                    </tr>
                <?php endforeach; ?>
                </tbody>
            </table>
        </div>
    <?php endif; ?>

    <!-- EXPENSE TABLE -->
    <?php if ($show_type !== 'sales'): ?>
        <h5 class="mt-4">Expenses Records</h5>
        <div class="table-responsive">
            <table class="table table-bordered">
                <thead class="table-dark">
                    <tr>
                        <th>Date</th>
                        <th>Expense Name</th>
                        <th>Category</th>
                        <th>Amount</th>
                    </tr>
                </thead>
                <tbody>
                <?php foreach($expenses as $row): ?>
                    <tr>
                        <td><?= $row['expense_date'] ?></td>
                        <td><?= htmlspecialchars($row['expense_name']) ?></td>
                        <td><?= htmlspecialchars($row['category']) ?></td>
                        <td><?= number_format($row['amount'],2) ?></td>
                    </tr>
                <?php endforeach; ?>
                </tbody>
            </table>
        </div>
    <?php endif; ?>

    <!-- Export Buttons -->
    <a href="export_sales_excel.php?<?= http_build_query($_GET) ?>" class="btn btn-success mt-3">Export to Excel</a>
    <a href="export_sales_pdf.php?<?= http_build_query($_GET) ?>" class="btn btn-danger mt-3">Export to PDF</a>

</div>

<?php include 'footer.php'; ?>
