<?php
/* ===================== sales_edit.php ===================== */
session_start();
include 'db.php';
include 'header.php';

$id = $_GET['id'] ?? null;
if(!$id){
    header("Location: sales.php");
    exit;
}

// Fetch sale
$stmt = $conn->prepare("SELECT * FROM sales WHERE id=?");
$stmt->bind_param("i", $id);
$stmt->execute();
$sale = $stmt->get_result()->fetch_assoc();
if(!$sale){
    echo "<div class='alert alert-danger'>Sale not found.</div>";
    include 'footer.php';
    exit;
}

// Fetch products & customers
$products = $conn->query("SELECT * FROM products ORDER BY name ASC");
$customers = $conn->query("SELECT * FROM customers ORDER BY name ASC");

// Handle update
if(isset($_POST['update'])){
    $customer_id = $_POST['customer_id'];
    $product_id = $_POST['product_id'];
    $quantity = (int)$_POST['quantity'];
    $sale_date = $_POST['sale_date'];

    // Fetch current product quantity
    $stmt = $conn->prepare("SELECT quantity, sale_price, cost_price FROM products WHERE id=?");
    $stmt->bind_param("i", $product_id);
    $stmt->execute();
    $product = $stmt->get_result()->fetch_assoc();
    if(!$product){
        $error = "Product not found.";
    } elseif($quantity > ($product['quantity'] + $sale['quantity'])) { 
        // Allow returning previous quantity back
        $error = "Not enough stock for selected product.";
    } else {
        $conn->begin_transaction();
        try {
            // Update stock: return previous sale quantity first
            $stmt = $conn->prepare("UPDATE products SET quantity = quantity + ? WHERE id=?");
            $stmt->bind_param("ii", $sale['quantity'], $sale['product_id']);
            $stmt->execute();

            // Deduct new quantity
            $stmt = $conn->prepare("UPDATE products SET quantity = quantity - ? WHERE id=?");
            $stmt->bind_param("ii", $quantity, $product_id);
            $stmt->execute();

            // Update sale
            $total = $product['sale_price'] * $quantity;
            $stmt = $conn->prepare("UPDATE sales SET customer_id=?, product_id=?, quantity=?, unit_price=?, total=?, sale_date=? WHERE id=?");
            $stmt->bind_param("iiiddsi", $customer_id, $product_id, $quantity, $product['sale_price'], $total, $sale_date, $id);
            $stmt->execute();

            $conn->commit();
            header("Location: sales.php");
            exit;
        } catch(Exception $e){
            $conn->rollback();
            $error = $e->getMessage();
        }
    }
}
?>

<div class="container mt-4">
    <h3>Edit Sale</h3>
    <?php if(isset($error)): ?>
        <div class="alert alert-danger"><?= $error ?></div>
    <?php endif; ?>

    <form method="POST" class="row g-3">
        <div class="col-md-4">
            <label>Customer</label>
            <select name="customer_id" class="form-control" required>
                <option value="">Select Customer</option>
                <?php while($c = $customers->fetch_assoc()): ?>
                    <option value="<?= $c['id'] ?>" <?= ($sale['customer_id']==$c['id'])?'selected':'' ?>><?= htmlspecialchars($c['name']) ?></option>
                <?php endwhile; ?>
            </select>
        </div>

        <div class="col-md-4">
            <label>Product</label>
            <select name="product_id" class="form-control" required>
                <option value="">Select Product</option>
                <?php 
                $products->data_seek(0);
                while($p = $products->fetch_assoc()): ?>
                    <option value="<?= $p['id'] ?>" data-price="<?= $p['sale_price'] ?>" <?= ($sale['product_id']==$p['id'])?'selected':'' ?>>
                        <?= htmlspecialchars($p['name']) ?> (Available: <?= $p['quantity'] ?>)
                    </option>
                <?php endwhile; ?>
            </select>
        </div>

        <div class="col-md-2">
            <label>Quantity</label>
            <input type="number" name="quantity" class="form-control" min="1" value="<?= $sale['quantity'] ?>" required>
        </div>

        <div class="col-md-2">
            <label>Sale Date</label>
            <input type="date" name="sale_date" class="form-control" value="<?= $sale['sale_date'] ?>" required>
        </div>

        <div class="col-md-2 mt-3">
            <button name="update" class="btn btn-primary w-100 mt-2">Update Sale</button>
        </div>
    </form>
</div>

<?php include 'footer.php'; ?>
