<?php
session_start();
include 'db.php';

$msg = "";

if($_SERVER['REQUEST_METHOD'] === 'POST'){
    $username = trim($_POST['username']);
    $new_pass = trim($_POST['new_password']);
    $confirm_pass = trim($_POST['confirm_password']);

    if($new_pass !== $confirm_pass){
        $msg = "Passwords do not match!";
    } else {
        $stmt = $conn->prepare("SELECT id FROM users WHERE username=?");
        $stmt->bind_param("s", $username);
        $stmt->execute();
        $result = $stmt->get_result();

        if($result->num_rows === 1){
            $row = $result->fetch_assoc();
            $update = $conn->prepare("UPDATE users SET password=? WHERE id=?");
            $update->bind_param("si", $new_pass, $row['id']); // plain text password
            $update->execute();
            $msg = "Password reset successfully! <a href='login.php'>Login</a>";
        } else {
            $msg = "Username not found!";
        }
    }
}
?>
<?php include 'headers.php'; ?>

<div class="container mt-5" style="max-width:400px;">
    <h3 class="mb-3 text-center">Reset Password</h3>
    <?php if($msg): ?>
        <div class="alert alert-info"><?= $msg ?></div>
    <?php endif; ?>

    <form method="POST">
        <div class="mb-3">
            <input class="form-control" name="username" placeholder="Username" required>
        </div>
        <div class="mb-3">
            <input class="form-control" type="password" name="new_password" placeholder="New Password" required>
        </div>
        <div class="mb-3">
            <input class="form-control" type="password" name="confirm_password" placeholder="Confirm Password" required>
        </div>
        <button class="btn btn-primary w-100">Reset Password</button>
    </form>
</div>

<?php include 'footer.php'; ?>
