<?php
/* ===================== products.php (Enhanced with Totals: Cost, Profit, Value) ===================== */
session_start();
include 'db.php';
include 'header.php';
// Handle Delete Product
if(isset($_GET['delete'])){
    $delete_id = (int)$_GET['delete'];

    // Optionally, check if product exists
    $stmt = $conn->prepare("SELECT * FROM products WHERE id = ?");
    $stmt->bind_param("i", $delete_id);
    $stmt->execute();
    $prod = $stmt->get_result()->fetch_assoc();

    if($prod){
        // Delete product
        $stmt = $conn->prepare("DELETE FROM products WHERE id = ?");
        $stmt->bind_param("i", $delete_id);
        $stmt->execute();
        header("Location: products.php?search=" . urlencode($_GET['search'] ?? ''));
        exit;
    } else {
        echo '<div class="alert alert-danger">Product not found!</div>';
    }
}


// Add product
if(isset($_POST['add'])){
    $sku = $_POST['sku'];
    $name = $_POST['name'];
    $description = $_POST['description'];
    $supplier = $_POST['supplier_id'];
    $cost = $_POST['cost_price'];
    $sale = $_POST['sale_price'];
    $qty = $_POST['quantity'];
    $reorder = $_POST['reorder_level'];

    $stmt = $conn->prepare("INSERT INTO products (sku,name,description,supplier_id,cost_price,sale_price,quantity,reorder_level) VALUES (?,?,?,?,?,?,?,?)");
    $stmt->bind_param("sssiddii", $sku, $name, $description, $supplier, $cost, $sale, $qty, $reorder);
    $stmt->execute();
    header('Location: products.php');
    exit;
}

// Handle Search
$search = isset($_GET['search']) ? $_GET['search'] : '';
$search_sql = $conn->real_escape_string($search);

// Pagination
$limit = 10;
$page = isset($_GET['page']) ? (int)$_GET['page'] : 1;
$offset = ($page - 1) * $limit;

// Fetch total count
$total_result = $conn->query("SELECT COUNT(*) as total FROM products WHERE name LIKE '%$search_sql%' OR sku LIKE '%$search_sql%'");
$total_row = $total_result->fetch_assoc();
$total = $total_row['total'];
$total_pages = ceil($total / $limit);

// Fetch products
$products = $conn->query("SELECT p.*, s.name as supplier_name FROM products p LEFT JOIN suppliers s ON p.supplier_id = s.id WHERE p.name LIKE '%$search_sql%' OR p.sku LIKE '%$search_sql%' ORDER BY p.name ASC LIMIT $offset, $limit");

// Fetch suppliers
$suppliers = $conn->query("SELECT * FROM suppliers ORDER BY name ASC");

// Calculate total cost, total sale value, and profit
$total_cost = 0;
$total_sale = 0;
$profit = 0;
$all_products = $conn->query("SELECT * FROM products");
while($p = $all_products->fetch_assoc()){
    $total_cost += $p['cost_price'] * $p['quantity'];
    $total_sale += $p['sale_price'] * $p['quantity'];
}
$profit = $total_sale - $total_cost;
?>

<div class="container mt-4">
    <h3 class="mb-3">Add New Product/Service</h3>

    <form method="POST" class="row g-3 mb-4">
        <div class="col-md-3"><input name="sku" class="form-control" placeholder="SKU" required></div>
        <div class="col-md-3"><input name="name" class="form-control" placeholder="Product Name" required></div>
        <div class="col-md-3"><input name="cost_price" class="form-control" placeholder="Cost Price" required></div>
        <div class="col-md-3"><input name="sale_price" class="form-control" placeholder="Sale Price" required></div>
        <div class="col-md-3"><input name="quantity" class="form-control" placeholder="Quantity" required></div>
        <div class="col-md-3"><input name="reorder_level" class="form-control" placeholder="Reorder Level" required></div>
        <div class="col-md-6"><textarea name="description" class="form-control" placeholder="Description"></textarea></div>
        <div class="col-md-4">
            <select name="supplier_id" class="form-control">
                <option value="">Choose Supplier</option>
                <?php while($s = $suppliers->fetch_assoc()): ?>
                    <option value="<?= $s['id'] ?>"><?= $s['name'] ?></option>
                <?php endwhile; ?>
            </select>
        </div>
        <div class="col-md-2"><button name="add" class="btn btn-primary w-100">Add Product</button></div>
    </form>

    <!-- Search Form -->
    <form method="GET" class="row g-3 mb-3">
        <div class="col-md-6">
            <input type="text" name="search" class="form-control" placeholder="Search by Name or SKU" value="<?= htmlspecialchars($search) ?>">
        </div>
        <div class="col-md-2">
            <button class="btn btn-primary w-100">Search</button>
        </div>
    </form>

    <!-- Export Buttons -->
    <a href="export_products_excel.php" class="btn btn-success btn-sm mb-2">Export to Excel</a>
    <a href="export_products_pdf.php" class="btn btn-danger btn-sm mb-2">Export to PDF</a>

    <!-- Products Table -->
    <div class="table-responsive">
        <table class="table table-bordered">
            <thead class="table-dark">
                <tr>
                    <th>SKU</th>
                    <th>Name</th>
                    <th>Supplier</th>
                    <th>Cost Price</th>
                    <th>Sale Price</th>
                    <th>Quantity</th>
                    <th>Reorder Level</th>
                    <th>Description</th>
                    <th>Actions</th>
                </tr>
            </thead>
            <tbody>
            <?php while($row = $products->fetch_assoc()): ?>
                <tr>
                    <td><?= htmlspecialchars($row['sku']) ?></td>
                    <td><?= htmlspecialchars($row['name']) ?></td>
                    <td><?= htmlspecialchars($row['supplier_name']) ?></td>
                    <td><?= htmlspecialchars($row['cost_price']) ?></td>
                    <td><?= htmlspecialchars($row['sale_price']) ?></td>
                    <td><?= htmlspecialchars($row['quantity']) ?></td>
                    <td><?= htmlspecialchars($row['reorder_level']) ?></td>
                    <td><?= htmlspecialchars($row['description']) ?></td>
                  <td>
    <?php if($_SESSION['role'] === 'admin'): ?>
        <a href="product_edit.php?id=<?= $row['id'] ?>" class="btn btn-warning btn-sm">Edit</a>
        <a href="products.php?delete=<?= $row['id'] ?>&search=<?= urlencode($search) ?>" 
           class="btn btn-danger btn-sm" 
           onclick="return confirm('Delete product?')">Delete</a>
    <?php else: ?>
        <span class="text-muted"><center><i class="fa fa-lock"></i></center>
</span>
    <?php endif; ?>
</td>

                </tr>
            <?php endwhile; ?>
            </tbody>
        </table>
    </div>

    <!-- Pagination -->
    <nav>
      <ul class="pagination">
        <?php for($i=1; $i<=$total_pages; $i++): ?>
            <li class="page-item <?= ($i==$page)?'active':'' ?>">
                <a class="page-link" href="?page=<?= $i ?>&search=<?= urlencode($search) ?>"><?= $i ?></a>
            </li>
        <?php endfor; ?>
      </ul>
    </nav>

    <p>Total Products: <?= $total ?></p>
    <p>Total Cost Value: <?= number_format($total_cost,2) ?></p>
    <p>Total Sale Value: <?= number_format($total_sale,2) ?></p>
    <p>Overall Profit: <?= number_format($profit,2) ?></p>
</div>

<?php include 'footer.php'; ?>
