<?php
/* ===================== product_edit.php ===================== */
session_start();
include 'db.php';
include 'header.php';

// Check if product ID is provided
if(!isset($_GET['id']) || empty($_GET['id'])){
    echo '<div class="alert alert-danger">Product ID missing!</div>';
    exit;
}

$id = (int)$_GET['id'];

// Fetch product details
$stmt = $conn->prepare("SELECT * FROM products WHERE id = ?");
$stmt->bind_param("i", $id);
$stmt->execute();
$product = $stmt->get_result()->fetch_assoc();

if(!$product){
    echo '<div class="alert alert-danger">Product not found!</div>';
    exit;
}

// Fetch suppliers for dropdown
$suppliers = $conn->query("SELECT * FROM suppliers ORDER BY name ASC");

// Handle update
if(isset($_POST['update'])){
    $sku = $_POST['sku'];
    $name = $_POST['name'];
    $description = $_POST['description'];
    $supplier = $_POST['supplier_id'];
    $cost = $_POST['cost_price'];
    $sale = $_POST['sale_price'];
    $qty = $_POST['quantity'];
    $reorder = $_POST['reorder_level'];

    $stmt = $conn->prepare("UPDATE products SET sku=?, name=?, description=?, supplier_id=?, cost_price=?, sale_price=?, quantity=?, reorder_level=? WHERE id=?");
    $stmt->bind_param("sssiddiii", $sku, $name, $description, $supplier, $cost, $sale, $qty, $reorder, $id);
    if($stmt->execute()){
        echo '<div class="alert alert-success">Product updated successfully!</div>';
        $product = array_merge($product, $_POST); // Update $product array with new values for form
    } else {
        echo '<div class="alert alert-danger">Update failed!</div>';
    }
}
?>

<div class="container mt-4">
    <h3>Edit Product</h3>
    <form method="POST" class="row g-3">
        <div class="col-md-3"><input name="sku" class="form-control" value="<?= htmlspecialchars($product['sku']) ?>" placeholder="SKU" required></div>
        <div class="col-md-3"><input name="name" class="form-control" value="<?= htmlspecialchars($product['name']) ?>" placeholder="Product Name" required></div>
        <div class="col-md-3"><input name="cost_price" class="form-control" value="<?= $product['cost_price'] ?>" placeholder="Cost Price" required></div>
        <div class="col-md-3"><input name="sale_price" class="form-control" value="<?= $product['sale_price'] ?>" placeholder="Sale Price" required></div>
        <div class="col-md-3"><input name="quantity" class="form-control" value="<?= $product['quantity'] ?>" placeholder="Quantity" required></div>
        <div class="col-md-3"><input name="reorder_level" class="form-control" value="<?= $product['reorder_level'] ?>" placeholder="Reorder Level" required></div>
        <div class="col-md-6"><textarea name="description" class="form-control" placeholder="Description"><?= htmlspecialchars($product['description']) ?></textarea></div>
        <div class="col-md-4">
            <select name="supplier_id" class="form-control" required>
                <option value="">Choose Supplier</option>
                <?php while($s = $suppliers->fetch_assoc()): ?>
                    <option value="<?= $s['id'] ?>" <?= ($s['id']==$product['supplier_id'])?'selected':'' ?>><?= htmlspecialchars($s['name']) ?></option>
                <?php endwhile; ?>
            </select>
        </div>
        <div class="col-md-2">
            <button name="update" class="btn btn-primary w-100">Update Product</button>
        </div>
    </form>
</div>

<?php include 'footer.php'; ?>
