<?php
session_start();
include 'db.php';

$msg = "";

// Redirect if already logged in
if(isset($_SESSION['uid'])){
    header("Location: dashboard.php");
    exit;
}

// Handle login
if($_SERVER['REQUEST_METHOD'] === 'POST'){
    $u = trim($_POST['username']);
    $p = trim($_POST['password']);

    // Prepare query to prevent SQL injection
    $stmt = $conn->prepare("SELECT id, username, password, role FROM users WHERE username=?");
    $stmt->bind_param("s", $u);
    $stmt->execute();
    $result = $stmt->get_result();

    if($result->num_rows === 1){
        $row = $result->fetch_assoc();
        if($row['password']){ // Use password_verify
            $_SESSION['uid'] = $row['id'];
            $_SESSION['role'] = $row['role'];
            header("Location: dashboard.php");
            exit;
        }
    }
    $msg = "Invalid username or password!";
}
?>
<?php include 'headers.php'; ?>

<div class="container mt-5" style="max-width:400px;">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.0/css/all.min.css">
  
    <h3 class="mb-3 text-center">  <i class="fas fa-shop" style="font-size: 30px; color: #000;">SHop</i>-Login</h3>
    <?php if($msg): ?>
        <div class="alert alert-danger"><?= htmlspecialchars($msg) ?></div>
    <?php endif; ?>
    
    <form method="POST">
        <div class="mb-3">
            <input class="form-control" name="username" placeholder="Username" required>
        </div>
        <div class="mb-3">
            <input class="form-control" type="password" name="password" placeholder="Password" required>
        </div>
        <button class="btn btn-success w-100">Login</button>
    </form>

    <div class="mt-3 text-center">
        <a href="reset_password.php">Forgot Password?</a>
    </div>
</div>

</div> <!-- Close main container -->

<style>html, body {
    height: 100%;
}

body {
    display: flex;
    flex-direction: column;
}

.container {
    flex: 1;
}
</style>
<footer class="bg-dark text-white text-center py-3 mt-auto">
    <small>Powered by GiantPlus &copy; 2025</small>
</footer>

<!-- Bootstrap JS -->
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>

