<?php
/* ===================== inventory_report.php (Enhanced) ===================== */
session_start();
include 'db.php';
include 'header.php';

// Filters
$from_date   = $_GET['from_date'] ?? '';
$to_date     = $_GET['to_date'] ?? '';
$search      = $_GET['search'] ?? '';
$supplier_id = $_GET['supplier_id'] ?? '';
$stock_filter = $_GET['stock_filter'] ?? ''; // all, low, out, instock

// Build WHERE conditions
$where = "1=1";

if ($from_date)   $where .= " AND p.created_at >= '$from_date'";
if ($to_date)     $where .= " AND p.created_at <= '$to_date'";
if ($search)      $where .= " AND (p.name LIKE '%$search%' OR p.sku LIKE '%$search%')";
if ($supplier_id) $where .= " AND p.supplier_id = '$supplier_id'";

if ($stock_filter == "low") {
    $where .= " AND p.quantity <= p.reorder_level AND p.quantity > 0";
}
elseif ($stock_filter == "out") {
    $where .= " AND p.quantity = 0";
}
elseif ($stock_filter == "instock") {
    $where .= " AND p.quantity > p.reorder_level";
}

// Fetch suppliers
$suppliers = $conn->query("SELECT * FROM suppliers ORDER BY name ASC");

// Fetch products
$products = $conn->query("
    SELECT p.*, s.name as supplier_name
    FROM products p
    LEFT JOIN suppliers s ON p.supplier_id = s.id
    WHERE $where
    ORDER BY p.name ASC
");

// Calculate totals
$total_cost = 0;
$total_value = 0;
$total_quantity = 0;
$total_items = 0;

?>
<div class="container mt-4">

    <h3 class="mb-3">Inventory Report</h3>

    <!-- Filter Form -->
    <form method="GET" class="row g-3 mb-4">

        <div class="col-md-2">
            <input type="date" name="from_date" value="<?= $from_date ?>" class="form-control" placeholder="From">
        </div>

        <div class="col-md-2">
            <input type="date" name="to_date" value="<?= $to_date ?>" class="form-control" placeholder="To">
        </div>

        <div class="col-md-3">
            <input type="text" name="search" value="<?= $search ?>" class="form-control" placeholder="Search Name/SKU">
        </div>

        <div class="col-md-3">
            <select name="supplier_id" class="form-control">
                <option value="">All Suppliers</option>
                <?php while($s = $suppliers->fetch_assoc()): ?>
                    <option value="<?= $s['id'] ?>" <?= ($supplier_id == $s['id']) ? 'selected' : '' ?>>
                        <?= $s['name'] ?>
                    </option>
                <?php endwhile; ?>
            </select>
        </div>

        <div class="col-md-2">
            <select name="stock_filter" class="form-control">
                <option value="">All Stock Levels</option>
                <option value="low"     <?= ($stock_filter=="low")?'selected':'' ?>>Low Stock</option>
                <option value="out"     <?= ($stock_filter=="out")?'selected':'' ?>>Out of Stock</option>
                <option value="instock" <?= ($stock_filter=="instock")?'selected':'' ?>>In Stock</option>
            </select>
        </div>

        <div class="col-md-2">
            <button class="btn btn-primary w-100">Filter</button>
        </div>

        <div class="col-md-2">
            <a href="inventory_report.php" class="btn btn-secondary w-100">Reset</a>
        </div>

    </form>

    <!-- Export Buttons -->
    <a href="export_inventory_excel.php?<?= http_build_query($_GET) ?>" class="btn btn-success btn-sm mb-2">
        Export to Excel
    </a>

    <a href="export_inventory_pdf.php?<?= http_build_query($_GET) ?>" class="btn btn-danger btn-sm mb-2">
        Export to PDF
    </a>

    <div class="table-responsive">
        <table class="table table-bordered table-striped table-hover">
            <thead class="table-dark">
                <tr>
                    <th>SKU</th>
                    <th>Name</th>
                    <th>Supplier</th>
                    <th>Cost Price</th>
                    <th>Sale Price</th>
                    <th>Quantity</th>
                    <th>Reorder Level</th>
                    <th>Total Cost</th>
                    <th>Total Value</th>
                </tr>
            </thead>

            <tbody>
            <?php while($row = $products->fetch_assoc()): ?>

                <?php
                $row_cost  = $row['quantity'] * $row['cost_price'];
                $row_value = $row['quantity'] * $row['sale_price'];

                $total_cost   += $row_cost;
                $total_value  += $row_value;
                $total_quantity += $row['quantity'];
                $total_items++;
                ?>

                <tr class="<?= ($row['quantity'] <= $row['reorder_level']) ? 'table-warning' : '' ?>">
                    <td><?= $row['sku'] ?></td>
                    <td><?= $row['name'] ?></td>
                    <td><?= $row['supplier_name'] ?: '-' ?></td>
                    <td><?= number_format($row['cost_price'], 2) ?></td>
                    <td><?= number_format($row['sale_price'], 2) ?></td>
                    <td><?= $row['quantity'] ?></td>
                    <td><?= $row['reorder_level'] ?></td>
                    <td><?= number_format($row_cost, 2) ?></td>
                    <td><?= number_format($row_value, 2) ?></td>
                </tr>

            <?php endwhile; ?>
            </tbody>
        </table>
    </div>

    <!-- Summary -->
    <div class="mt-4 p-3 bg-light border rounded">

        <p><strong>Total Items Listed:</strong> <?= $total_items ?></p>
        <p><strong>Total Quantity:</strong> <?= $total_quantity ?></p>
        <p><strong>Total Cost Value:</strong> <?= number_format($total_cost, 2) ?></p>
        <p><strong>Total Sale Value:</strong> <?= number_format($total_value, 2) ?></p>

        <?php if ($total_quantity > 0): ?>
            <p><strong>Average Cost Price:</strong> 
                <?= number_format($total_cost / $total_quantity, 2) ?>
            </p>
            <p><strong>Average Sale Price:</strong> 
                <?= number_format($total_value / $total_quantity, 2) ?>
            </p>
        <?php endif; ?>

    </div>

</div>

<?php include 'footer.php'; ?>
