<?php
// export_sales_pdf.php
require 'dompdf/vendor/autoload.php'; // make sure Dompdf is installed via Composer
include 'db.php';

use Dompdf\Dompdf;

// Get search and date filters
$search = $_GET['search'] ?? '';
$from_date = $_GET['from_date'] ?? '';
$to_date = $_GET['to_date'] ?? '';

$search_sql = $conn->real_escape_string($search);
$where = "1=1";

if($search_sql) $where .= " AND p.name LIKE '%$search_sql%'";
if($from_date) $where .= " AND s.sale_date >= '$from_date'";
if($to_date) $where .= " AND s.sale_date <= '$to_date'";

// Fetch sales
$query = "SELECT s.*, p.name as product_name, c.name as customer_name
          FROM sales s
          LEFT JOIN products p ON s.product_id=p.id
          LEFT JOIN customers c ON s.customer_id=c.id
          WHERE $where
          ORDER BY s.sale_date DESC";

$result = $conn->query($query);

// Prepare HTML for PDF
$html = '<h3 style="text-align:center;">Sales Report</h3>';
$html .= '<table border="1" width="100%" cellspacing="0" cellpadding="5">';
$html .= '<thead>
            <tr style="background-color:#ddd;">
                <th>Customer</th>
                <th>Product</th>
                <th>Quantity</th>
                <th>Unit Price</th>
                <th>Total</th>
                <th>Sale Date</th>
            </tr>
          </thead><tbody>';

$total_sales = 0;

while($row = $result->fetch_assoc()){
    $total = $row['quantity'] * $row['unit_price'];
    $total_sales += $total;
    $html .= '<tr>
                <td>'.htmlspecialchars($row['customer_name'] ?? '-').'</td>
                <td>'.htmlspecialchars($row['product_name']).'</td>
                <td>'.$row['quantity'].'</td>
                <td>'.number_format($row['unit_price'],2).'</td>
                <td>'.number_format($total,2).'</td>
                <td>'.$row['sale_date'].'</td>
              </tr>';
}

// Total row
$html .= '<tr>
            <td colspan="4" style="text-align:right;"><strong>Total Sales Amount</strong></td>
            <td colspan="2"><strong>'.number_format($total_sales,2).'</strong></td>
          </tr>';

$html .= '</tbody></table>';

// Generate PDF
$dompdf = new Dompdf();
$dompdf->loadHtml($html);
$dompdf->setPaper('A4', 'portrait');
$dompdf->render();
$dompdf->stream("sales_report.pdf", ["Attachment" => true]);
exit;
?>
