<?php
// export_sales_excel.php
include 'db.php';

$search = $_GET['search'] ?? '';
$search_sql = $conn->real_escape_string($search);

// Optional date filters
$from_date = $_GET['from_date'] ?? '';
$to_date = $_GET['to_date'] ?? '';
$where = "1=1";

if($search_sql) $where .= " AND p.name LIKE '%$search_sql%'";
if($from_date) $where .= " AND s.sale_date >= '$from_date'";
if($to_date) $where .= " AND s.sale_date <= '$to_date'";

// Set headers for Excel export
header("Content-Type: application/vnd.ms-excel");
header("Content-Disposition: attachment; filename=sales.xls");

// Table header
echo "<table border='1'>";
echo "<tr>
        <th>Customer</th>
        <th>Product</th>
        <th>Quantity</th>
        <th>Unit Price</th>
        <th>Total</th>
        <th>Sale Date</th>
      </tr>";

// Fetch sales
$query = "SELECT s.*, p.name as product_name, c.name as customer_name
          FROM sales s
          LEFT JOIN products p ON s.product_id=p.id
          LEFT JOIN customers c ON s.customer_id=c.id
          WHERE $where
          ORDER BY s.sale_date DESC";

$result = $conn->query($query);
$total_sales = 0;

while($row = $result->fetch_assoc()){
    $total = $row['quantity'] * $row['unit_price'];
    $total_sales += $total;
    echo "<tr>";
    echo "<td>".htmlspecialchars($row['customer_name'] ?? '-')."</td>";
    echo "<td>".htmlspecialchars($row['product_name'])."</td>";
    echo "<td>".$row['quantity']."</td>";
    echo "<td>".number_format($row['unit_price'],2)."</td>";
    echo "<td>".number_format($total,2)."</td>";
    echo "<td>".$row['sale_date']."</td>";
    echo "</tr>";
}

// Optional: Add total sales row
echo "<tr>
        <td colspan='4'><strong>Total Sales Amount</strong></td>
        <td colspan='2'><strong>".number_format($total_sales,2)."</strong></td>
      </tr>";

echo "</table>";
exit;
?>
