<?php
// export_products_pdf.php
session_start();
if(!isset($_SESSION['uid'])){
    header("Location: login.php");
    exit;
}

include 'db.php';
require 'dompdf/vendor/autoload.php'; // Adjust path if using Composer

use Dompdf\Dompdf;

// Fetch products with supplier names
$query = "SELECT p.sku, p.name, p.description, s.name as supplier, p.cost_price, p.sale_price, p.quantity, p.reorder_level 
          FROM products p 
          LEFT JOIN suppliers s ON p.supplier_id = s.id 
          ORDER BY p.name ASC";
$result = $conn->query($query);

// Build HTML table
$html = '<h2 style="text-align:center;">Products Report</h2>';
$html .= '<table border="1" cellspacing="0" cellpadding="5" width="100%">
            <thead style="background-color:#cccccc;">
                <tr>
                    <th>SKU</th>
                    <th>Name</th>
                    <th>Description</th>
                    <th>Supplier</th>
                    <th>Cost Price</th>
                    <th>Sale Price</th>
                    <th>Quantity</th>
                    <th>Reorder Level</th>
                </tr>
            </thead>
            <tbody>';

while($row = $result->fetch_assoc()){
    $html .= '<tr>
                <td>'.htmlspecialchars($row['sku']).'</td>
                <td>'.htmlspecialchars($row['name']).'</td>
                <td>'.htmlspecialchars($row['description']).'</td>
                <td>'.htmlspecialchars($row['supplier']).'</td>
                <td>'.$row['cost_price'].'</td>
                <td>'.$row['sale_price'].'</td>
                <td>'.$row['quantity'].'</td>
                <td>'.$row['reorder_level'].'</td>
              </tr>';
}

$html .= '</tbody></table>';

// Initialize Dompdf
$dompdf = new Dompdf();
$dompdf->loadHtml($html);

// (Optional) Setup paper size and orientation
$dompdf->setPaper('A4', 'landscape');

// Render PDF
$dompdf->render();

// Output the PDF to browser
$dompdf->stream("products_report_" . date('Y-m-d') . ".pdf", ["Attachment" => false]);
exit;
?>
