<?php
// export_products_excel.php
session_start();
if(!isset($_SESSION['uid'])){
    header("Location: login.php");
    exit;
}

include 'db.php';

// Fetch all products with supplier names
$query = "SELECT p.sku, p.name, p.description, s.name as supplier, p.cost_price, p.sale_price, p.quantity, p.reorder_level 
          FROM products p 
          LEFT JOIN suppliers s ON p.supplier_id = s.id 
          ORDER BY p.name ASC";
$result = $conn->query($query);

// Set headers to force download as Excel file
header("Content-Type: application/vnd.ms-excel");
header("Content-Disposition: attachment; filename=products_" . date('Y-m-d') . ".xls");
header("Pragma: no-cache");
header("Expires: 0");

// Output column headers
echo "SKU\tName\tDescription\tSupplier\tCost Price\tSale Price\tQuantity\tReorder Level\n";

// Output rows
while($row = $result->fetch_assoc()){
    echo $row['sku'] . "\t" .
         $row['name'] . "\t" .
         $row['description'] . "\t" .
         $row['supplier'] . "\t" .
         $row['cost_price'] . "\t" .
         $row['sale_price'] . "\t" .
         $row['quantity'] . "\t" .
         $row['reorder_level'] . "\n";
}

exit;
?>
