<?php
/* ===================== export_inventory_pdf.php ===================== */
session_start();
include 'db.php';

// Include Dompdf
require_once 'dompdf/vendor/autoload.php';
use Dompdf\Dompdf;

// Fetch products with supplier names
$products = $conn->query("
    SELECT p.*, s.name AS supplier_name 
    FROM products p 
    LEFT JOIN suppliers s ON p.supplier_id = s.id
    ORDER BY p.name ASC
");

// Start HTML for PDF
$html = '<h3 style="text-align:center;">Inventory Report</h3>';
$html .= '<table border="1" cellpadding="5" cellspacing="0" width="100%">';
$html .= '<thead>
            <tr style="background-color:#333;color:#fff;">
                <th>ID</th>
                <th>SKU</th>
                <th>Name</th>
                <th>Supplier</th>
                <th>Cost Price</th>
                <th>Sale Price</th>
                <th>Quantity</th>
                <th>Reorder Level</th>
                <th>Description</th>
            </tr>
          </thead><tbody>';

while ($row = $products->fetch_assoc()) {
    $html .= '<tr>
                <td>'.$row['id'].'</td>
                <td>'.htmlspecialchars($row['sku']).'</td>
                <td>'.htmlspecialchars($row['name']).'</td>
                <td>'.htmlspecialchars($row['supplier_name']).'</td>
                <td>'.number_format($row['cost_price'],2).'</td>
                <td>'.number_format($row['sale_price'],2).'</td>
                <td>'.$row['quantity'].'</td>
                <td>'.$row['reorder_level'].'</td>
                <td>'.htmlspecialchars($row['description']).'</td>
              </tr>';
}

$html .= '</tbody></table>';

// Optional footer
$html .= '<p style="text-align:center;margin-top:20px;font-size:12px;">Powered by GiantPlus &copy; 2025</p>';

// Initialize Dompdf
$dompdf = new Dompdf();
$dompdf->loadHtml($html);

// Setup paper size and orientation
$dompdf->setPaper('A4', 'landscape');

// Render the PDF
$dompdf->render();

// Output PDF to browser for download
$dompdf->stream("inventory_report_" . date('Y-m-d') . ".pdf", array("Attachment" => 1));
exit;
