<?php
/* ===================== export_inventory_excel.php ===================== */
session_start();
include 'db.php';

// Fetch products with supplier names
$products = $conn->query("
    SELECT p.*, s.name AS supplier_name 
    FROM products p 
    LEFT JOIN suppliers s ON p.supplier_id = s.id
    ORDER BY p.name ASC
");

// Set headers to download file as Excel
header("Content-Type: application/vnd.ms-excel");
header("Content-Disposition: attachment; filename=inventory_" . date('Y-m-d') . ".xls");
header("Pragma: no-cache");
header("Expires: 0");

// Start Excel output
echo "<table border='1'>";
echo "<thead>
        <tr style='background-color:#333;color:#fff;'>
            <th>ID</th>
            <th>SKU</th>
            <th>Name</th>
            <th>Supplier</th>
            <th>Cost Price</th>
            <th>Sale Price</th>
            <th>Quantity</th>
            <th>Reorder Level</th>
            <th>Description</th>
        </tr>
      </thead><tbody>";

// Populate rows
while ($row = $products->fetch_assoc()) {
    echo "<tr>
            <td>".$row['id']."</td>
            <td>".htmlspecialchars($row['sku'])."</td>
            <td>".htmlspecialchars($row['name'])."</td>
            <td>".htmlspecialchars($row['supplier_name'])."</td>
            <td>".number_format($row['cost_price'],2)."</td>
            <td>".number_format($row['sale_price'],2)."</td>
            <td>".$row['quantity']."</td>
            <td>".$row['reorder_level']."</td>
            <td>".htmlspecialchars($row['description'])."</td>
          </tr>";
}

echo "</tbody></table>";
exit;
