<?php
// export_expenses_pdf.php
require 'dompdf/vendor/autoload.php'; // adjust path if needed
use Dompdf\Dompdf;

include 'db.php';

$search = $_GET['search'] ?? '';
$from_date = $_GET['from_date'] ?? '';
$to_date = $_GET['to_date'] ?? '';

$search_sql = $conn->real_escape_string($search);
$where = "1=1";
if($search_sql) $where .= " AND (expense_name LIKE '%$search_sql%' OR category LIKE '%$search_sql%')";
if($from_date) $where .= " AND expense_date >= '$from_date'";
if($to_date) $where .= " AND expense_date <= '$to_date'";

$result = $conn->query("SELECT * FROM expenses WHERE $where ORDER BY expense_date DESC");

$html = '<h3>Expenses Report</h3>';
$html .= '<table border="1" width="100%" style="border-collapse: collapse;">';
$html .= '<tr style="background-color: #333; color: #fff;">
            <th>Expense Name</th>
            <th>Amount</th>
            <th>Category</th>
            <th>Date</th>
          </tr>';

while($row = $result->fetch_assoc()){
    $html .= '<tr>
                <td>'.htmlspecialchars($row['expense_name']).'</td>
                <td>'.number_format($row['amount'],2).'</td>
                <td>'.htmlspecialchars($row['category']).'</td>
                <td>'.$row['expense_date'].'</td>
              </tr>';
}
$html .= '</table>';

$dompdf = new Dompdf();
$dompdf->loadHtml($html);
$dompdf->setPaper('A4','portrait');
$dompdf->render();
$dompdf->stream("expenses_report.pdf", ["Attachment" => true]);
exit;
?>
