<?php
/* ===================== export_customers_pdf.php ===================== */
session_start();
include 'db.php';

// Include Dompdf
require_once 'dompdf/vendor/autoload.php'; // Make sure dompdf is installed via Composer
use Dompdf\Dompdf;

// Fetch customers
$customers = $conn->query("SELECT * FROM customers ORDER BY name ASC");

// Start HTML for PDF
$html = '<h3 style="text-align:center;">Customers List</h3>';
$html .= '<table border="1" cellpadding="5" cellspacing="0" width="100%">';
$html .= '<thead>
            <tr style="background-color:#333;color:#fff;">
                <th>ID</th>
                <th>Name</th>
                <th>Phone</th>
                <th>Email</th>
                <th>Address</th>
            </tr>
          </thead><tbody>';

while ($row = $customers->fetch_assoc()) {
    $html .= '<tr>
                <td>'.$row['id'].'</td>
                <td>'.htmlspecialchars($row['name']).'</td>
                <td>'.htmlspecialchars($row['phone']).'</td>
                <td>'.htmlspecialchars($row['email']).'</td>
                <td>'.htmlspecialchars($row['address']).'</td>
              </tr>';
}

$html .= '</tbody></table>';

// Initialize Dompdf
$dompdf = new Dompdf();
$dompdf->loadHtml($html);

// (Optional) Setup paper size and orientation
$dompdf->setPaper('A4', 'portrait');

// Render the PDF
$dompdf->render();

// Output PDF to browser
$dompdf->stream("customers_" . date('Y-m-d') . ".pdf", array("Attachment" => 1));
exit;
