<?php
/* ===================== expenses.php ===================== */
session_start();
include 'db.php';
include 'header.php';

// Add Expense
if(isset($_POST['add'])){
    $name = $_POST['expense_name'];
    $amount = $_POST['amount'];
    $date = $_POST['expense_date'];
    $category = $_POST['category'];

    $stmt = $conn->prepare("INSERT INTO expenses (expense_name, amount, expense_date, category) VALUES (?,?,?,?)");
    $stmt->bind_param("sdss", $name, $amount, $date, $category);
    $stmt->execute();
    header("Location: expenses.php");
    exit;
}

// Delete Expense
if(isset($_GET['delete'])){
    $id = $_GET['delete'];
    $stmt = $conn->prepare("DELETE FROM expenses WHERE id=?");
    $stmt->bind_param("i", $id);
    $stmt->execute();
    header("Location: expenses.php");
    exit;
}

// Search & Pagination
$search = $_GET['search'] ?? '';
$from_date = $_GET['from_date'] ?? '';
$to_date = $_GET['to_date'] ?? '';
$search_sql = $conn->real_escape_string($search);
$limit = 10;
$page = isset($_GET['page']) ? (int)$_GET['page'] : 1;
$offset = ($page-1)*$limit;

// Build WHERE conditions
$where = "1=1";
if($search_sql) $where .= " AND (expense_name LIKE '%$search_sql%' OR category LIKE '%$search_sql%')";
if($from_date) $where .= " AND expense_date >= '$from_date'";
if($to_date) $where .= " AND expense_date <= '$to_date'";

// Fetch total count
$total_result = $conn->query("SELECT COUNT(*) as total FROM expenses WHERE $where");
$total_row = $total_result->fetch_assoc();
$total = $total_row['total'];
$total_pages = ceil($total / $limit);

// Fetch expenses
$expenses = $conn->query("SELECT * FROM expenses WHERE $where ORDER BY expense_date DESC LIMIT $offset,$limit");

// Calculate total expenses
$total_expense_amount = 0;
$all_expenses = $conn->query("SELECT amount FROM expenses WHERE $where");
while($row = $all_expenses->fetch_assoc()){
    $total_expense_amount += $row['amount'];
}

// Calculate today's total
$today = date('Y-m-d');
$today_total_result = $conn->query("SELECT SUM(amount) as today_total FROM expenses WHERE expense_date='$today'");
$today_total_row = $today_total_result->fetch_assoc();
$today_total = $today_total_row['today_total'] ?? 0;
?>

<div class="container mt-4">
    <h3 class="mb-3">Expenses</h3>

    <!-- Add Expense Form -->
    <form method="POST" class="row g-3 mb-4">
        <div class="col-md-3"><input type="text" name="expense_name" class="form-control" placeholder="Expense Name" required></div>
        <div class="col-md-2"><input type="number" step="0.01" name="amount" class="form-control" placeholder="Amount" required></div>
        <div class="col-md-3"><input type="date" name="expense_date" class="form-control" value="<?= date('Y-m-d') ?>" required></div>
        <div class="col-md-2"><input type="text" name="category" class="form-control" placeholder="Category"></div>
        <div class="col-md-2"><button name="add" class="btn btn-primary w-100">Add Expense</button></div>
    </form>

    <!-- Search & Date Range Form -->
    <form method="GET" class="row g-3 mb-3">
        <div class="col-md-3"><input type="text" name="search" class="form-control" placeholder="Search by Name or Category" value="<?= htmlspecialchars($search) ?>"></div>
        <div class="col-md-3"><input type="date" name="from_date" class="form-control" value="<?= htmlspecialchars($from_date) ?>"></div>
        <div class="col-md-3"><input type="date" name="to_date" class="form-control" value="<?= htmlspecialchars($to_date) ?>"></div>
        <div class="col-md-3"><button class="btn btn-primary w-100">Filter</button></div>
    </form>
<!-- Export Buttons -->
<a href="export_expenses_excel.php?search=<?= urlencode($search) ?>&from_date=<?= $from_date ?>&to_date=<?= $to_date ?>" class="btn btn-success btn-sm mb-2">Export to Excel</a>
<a href="export_expenses_pdf.php?search=<?= urlencode($search) ?>&from_date=<?= $from_date ?>&to_date=<?= $to_date ?>" class="btn btn-danger btn-sm mb-2">Export to PDF</a>

    <!-- Expenses Table -->
    <div class="table-responsive">
        <table class="table table-bordered">
            <thead class="table-dark">
                <tr>
                    <th>Expense Name</th>
                    <th>Amount</th>
                    <th>Category</th>
                    <th>Date</th>
                    <th>Actions</th>
                </tr>
            </thead>
            <tbody>
            <?php while($row = $expenses->fetch_assoc()): ?>
                <tr>
                    <td><?= htmlspecialchars($row['expense_name']) ?></td>
                    <td><?= number_format($row['amount'],2) ?></td>
                    <td><?= htmlspecialchars($row['category']) ?></td>
                    <td><?= $row['expense_date'] ?></td>
                    <td><?php if($_SESSION['role'] === 'admin'): ?>
                        <a href="expense_edit.php?id=<?= $row['id'] ?>" class="btn btn-warning btn-sm">Edit</a>
                        <a href="expenses.php?delete=<?= $row['id'] ?>&search=<?= urlencode($search) ?>" class="btn btn-danger btn-sm" onclick="return confirm('Delete this expense?')">Delete</a>
                                                     <?php else: ?>
        <span class="text-muted"><center><i class="fa fa-lock"></i></center>
</span>
    <?php endif; ?>
                    </td>
                </tr>
            <?php endwhile; ?>
            </tbody>
        </table>
    </div>

    <!-- Pagination -->
    <nav>
        <ul class="pagination">
        <?php for($i=1; $i<=$total_pages; $i++): ?>
            <li class="page-item <?= ($i==$page)?'active':'' ?>">
                <a class="page-link" href="?page=<?= $i ?>&search=<?= urlencode($search) ?>&from_date=<?= $from_date ?>&to_date=<?= $to_date ?>"><?= $i ?></a>
            </li>
        <?php endfor; ?>
        </ul>
    </nav>

    <p><strong>Total Expenses (Filtered):</strong> <?= number_format($total_expense_amount,2) ?></p>
    <p><strong>Today's Total:</strong> <?= number_format($today_total,2) ?></p>
</div>

<?php include 'footer.php'; ?>
