<?php
/* ===================== expense_edit.php ===================== */
session_start();
include 'db.php';
include 'header.php';

if(!isset($_GET['id'])){
    header("Location: expenses.php");
    exit;
}

$id = (int)$_GET['id'];
$msg = "";

// Fetch expense data
$stmt = $conn->prepare("SELECT * FROM expenses WHERE id=?");
$stmt->bind_param("i", $id);
$stmt->execute();
$result = $stmt->get_result();

if($result->num_rows !== 1){
    echo "<div class='alert alert-danger'>Expense not found!</div>";
    include 'footer.php';
    exit;
}

$expense = $result->fetch_assoc();

// Handle update
if(isset($_POST['update'])){
    $name = $_POST['expense_name'];
    $amount = $_POST['amount'];
    $date = $_POST['expense_date'];
    $category = $_POST['category'];

    $stmt = $conn->prepare("UPDATE expenses SET expense_name=?, amount=?, expense_date=?, category=? WHERE id=?");
    $stmt->bind_param("sdssi", $name, $amount, $date, $category, $id);
    if($stmt->execute()){
        header("Location: expenses.php");
        exit;
    } else {
        $msg = "Failed to update expense!";
    }
}
?>

<div class="container mt-4">
    <h3>Edit Expense</h3>
    <?php if($msg): ?>
        <div class="alert alert-danger"><?= $msg ?></div>
    <?php endif; ?>

    <form method="POST" class="row g-3">
        <div class="col-md-3">
            <input type="text" name="expense_name" class="form-control" placeholder="Expense Name" value="<?= htmlspecialchars($expense['expense_name']) ?>" required>
        </div>
        <div class="col-md-2">
            <input type="number" step="0.01" name="amount" class="form-control" placeholder="Amount" value="<?= $expense['amount'] ?>" required>
        </div>
        <div class="col-md-3">
            <input type="date" name="expense_date" class="form-control" value="<?= $expense['expense_date'] ?>" required>
        </div>
        <div class="col-md-2">
            <input type="text" name="category" class="form-control" placeholder="Category" value="<?= htmlspecialchars($expense['category']) ?>">
        </div>
        <div class="col-md-2">
            <button name="update" class="btn btn-success w-100">Update Expense</button>
        </div>
    </form>
</div>

<?php include 'footer.php'; ?>
