<?php
/* ===================== dashboard.php (Enhanced) ===================== */
session_start();
if (!isset($_SESSION['uid'])) {
    header("Location: login.php");
    exit;
}
include 'db.php';
include 'header.php';

/* ========================================================
   Fetch Key Metrics
======================================================== */

// Total products
$total_products = $conn->query("SELECT COUNT(*) AS t FROM products")->fetch_assoc()['t'];

// Low stock
$low_stock = $conn->query("SELECT COUNT(*) AS t FROM products WHERE quantity <= reorder_level")->fetch_assoc()['t'];

// Sales totals
$total_sales = $conn->query("SELECT SUM(total) AS s FROM sales")->fetch_assoc()['s'] ?? 0;

// Expense totals
$total_expenses = $conn->query("SELECT SUM(amount) AS a FROM expenses")->fetch_assoc()['a'] ?? 0;

// Customers
$total_customers = $conn->query("SELECT COUNT(*) AS c FROM customers")->fetch_assoc()['c'];

// Balance
$balance = $total_sales - $total_expenses;

/* ========================================================
   Fetch charts data
======================================================== */

// Sales last 7 days
$sales_7 = $conn->query("
    SELECT DATE(sale_date) AS d, SUM(total) AS amount 
    FROM sales 
    WHERE sale_date >= DATE(NOW() - INTERVAL 7 DAY)
    GROUP BY DATE(sale_date)
");

// Expenses last 7 days
$exp_7 = $conn->query("
    SELECT DATE(expense_date) AS d, SUM(amount) AS amount 
    FROM expenses
    WHERE expense_date >= DATE(NOW() - INTERVAL 7 DAY)
    GROUP BY DATE(expense_date)
");

// Top-selling products
$top_products = $conn->query("
    SELECT p.name, SUM(s.quantity) AS qty
    FROM sales s
    JOIN products p ON s.product_id = p.id
    GROUP BY s.product_id
    ORDER BY qty DESC
    LIMIT 5
");

// Recent transactions (last 5)
$recent_sales = $conn->query("
    SELECT s.sale_date, p.name, s.total 
    FROM sales s
    JOIN products p ON s.product_id = p.id
    ORDER BY s.id DESC
    LIMIT 5
");

$recent_expenses = $conn->query("
    SELECT expense_date, expense_name, amount
    FROM expenses
    ORDER BY id DESC
    LIMIT 5
");
?>

<div class="container mt-4">
    <h3>Dashboard</h3>
    <p>Welcome to Stationery Shop Management System</p>

    <!-- SUMMARY CARDS -->
    <div class="row mt-4">

        <div class="col-md-3 mb-3">
            <div class="card text-white bg-primary">
                <div class="card-body">
                    <h5>Total Products</h5>
                    <p class="display-6"><?= $total_products ?></p>
                </div>
            </div>
        </div>

        <div class="col-md-3 mb-3">
            <div class="card text-white bg-warning">
                <div class="card-body">
                    <h5>Low Stock</h5>
                    <p class="display-6"><?= $low_stock ?></p>
                </div>
            </div>
        </div>

        <div class="col-md-3 mb-3">
            <div class="card text-white bg-success">
                <div class="card-body">
                    <h5>Total Sales</h5>
                    <p class="display-6"><?= number_format($total_sales,2) ?></p>
                </div>
            </div>
        </div>

        <div class="col-md-3 mb-3">
            <div class="card text-white bg-danger">
                <div class="card-body">
                    <h5>Total Expenses</h5>
                    <p class="display-6"><?= number_format($total_expenses,2) ?></p>
                </div>
            </div>
        </div>

        <div class="col-md-3 mb-3">
            <div class="card text-white bg-info">
                <div class="card-body">
                    <h5>Balance</h5>
                    <p class="display-6"><?= number_format($balance,2) ?></p>
                </div>
            </div>
        </div>

        <div class="col-md-3 mb-3">
            <div class="card text-white bg-secondary">
                <div class="card-body">
                    <h5>Total Customers</h5>
                    <p class="display-6"><?= $total_customers ?></p>
                </div>
            </div>
        </div>

    </div>

    <!-- LOW STOCK ALERT -->
    <?php if ($low_stock > 0): ?>
    <div class="alert alert-danger">
        ⚠ <strong>Warning:</strong> You have <strong><?= $low_stock ?></strong> product(s) running low on stock!
        <a href="products.php" class="btn btn-sm btn-dark float-end">View Products</a>
    </div>
    <?php endif; ?>

    <!-- CHARTS -->
    <h4 class="mt-4">Sales & Expenses (Last 7 Days)</h4>

    <canvas id="chart" height="120"></canvas>

    <script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
    <script>
        const labels = [
            <?php foreach($sales_7 as $s){ echo '"' . $s['d'] . '",'; } ?>
        ];

        const salesData = [
            <?php $sales_7->data_seek(0); foreach($sales_7 as $s){ echo $s['amount'] . ','; } ?>
        ];

        const expenseLabels = [
            <?php foreach($exp_7 as $e){ echo '"' . $e['d'] . '",'; } ?>
        ];

        const expenseData = [
            <?php $exp_7->data_seek(0); foreach($exp_7 as $e){ echo $e['amount'] . ','; } ?>
        ];

        new Chart(document.getElementById('chart'), {
            type: 'line',
            data: {
                labels: labels,
                datasets: [
                    {
                        label: "Sales",
                        data: salesData,
                        borderColor: "green",
                        borderWidth: 2
                    },
                    {
                        label: "Expenses",
                        data: expenseData,
                        borderColor: "red",
                        borderWidth: 2
                    }
                ]
            }
        });
    </script>

    <!-- TOP SELLING PRODUCTS -->
    <h4 class="mt-5">Top Selling Products</h4>
    <table class="table table-bordered">
        <thead class="table-dark">
            <tr><th>Product</th><th>Quantity Sold</th></tr>
        </thead>
        <tbody>
            <?php foreach($top_products as $p): ?>
            <tr>
                <td><?= $p['name'] ?></td>
                <td><?= $p['qty'] ?></td>
            </tr>
            <?php endforeach; ?>
        </tbody>
    </table>

    <!-- RECENT ACTIVITY -->
    <div class="row mt-4">

        <div class="col-md-6">
            <h4>Recent Sales</h4>
            <table class="table table-hover table-bordered">
                <thead class="table-light">
                    <tr><th>Date</th><th>Product</th><th>Total</th></tr>
                </thead>
                <tbody>
                <?php foreach($recent_sales as $s): ?>
                    <tr>
                        <td><?= $s['sale_date'] ?></td>
                        <td><?= $s['name'] ?></td>
                        <td><?= number_format($s['total'],2) ?></td>
                    </tr>
                <?php endforeach; ?>
                </tbody>
            </table>
        </div>

        <div class="col-md-6">
            <h4>Recent Expenses</h4>
            <table class="table table-hover table-bordered">
                <thead class="table-light">
                    <tr><th>Date</th><th>Name</th><th>Amount</th></tr>
                </thead>
                <tbody>
                <?php foreach($recent_expenses as $e): ?>
                    <tr>
                        <td><?= $e['expense_date'] ?></td>
                        <td><?= $e['expense_name'] ?></td>
                        <td><?= number_format($e['amount'],2) ?></td>
                    </tr>
                <?php endforeach; ?>
                </tbody>
            </table>
        </div>

    </div>

    <!-- QUICK ACCESS -->
    <h4 class="mt-4">Quick Access</h4>
    <div class="row">

        <div class="col-md-2 mb-3">
            <a href="products.php" class="btn btn-outline-primary w-100">Products</a>
        </div>
        <div class="col-md-2 mb-3">
            <a href="suppliers.php" class="btn btn-outline-success w-100">Suppliers</a>
        </div>
        <div class="col-md-2 mb-3">
            <a href="customers.php" class="btn btn-outline-warning w-100">Customers</a>
        </div>
        <div class="col-md-2 mb-3">
            <a href="sales.php" class="btn btn-outline-danger w-100">Sales</a>
        </div>
        <div class="col-md-2 mb-3">
            <a href="expenses.php" class="btn btn-outline-info w-100">Expenses</a>
        </div>
        <div class="col-md-2 mb-3">
            <a href="inventory_report.php" class="btn btn-outline-secondary w-100">Inventory</a>
        </div>

    </div>

</div>

<?php include 'footer.php'; ?>
