<?php
/* ===================== customer_edit.php ===================== */
session_start();
include 'db.php';
include 'header.php';

$id = $_GET['id'] ?? null;
if (!$id) {
    header("Location: customers.php");
    exit;
}

// Fetch customer
$stmt = $conn->prepare("SELECT * FROM customers WHERE id=?");
$stmt->bind_param("i", $id);
$stmt->execute();
$customer = $stmt->get_result()->fetch_assoc();

if (!$customer) {
    echo "<div class='alert alert-danger'>Customer not found.</div>";
    include 'footer.php';
    exit;
}

// Handle update
if (isset($_POST['update'])) {
    $name = $_POST['name'];
    $phone = $_POST['phone'];
    $email = $_POST['email'];
    $address = $_POST['address'];

    $stmt = $conn->prepare("UPDATE customers SET name=?, phone=?, email=?, address=? WHERE id=?");
    $stmt->bind_param("ssssi", $name, $phone, $email, $address, $id);
    if ($stmt->execute()) {
        header("Location: customers.php");
        exit;
    } else {
        $error = "Failed to update customer.";
    }
}
?>

<div class="container mt-4">
    <h3>Edit Customer</h3>

    <?php if (isset($error)): ?>
        <div class="alert alert-danger"><?= $error ?></div>
    <?php endif; ?>

    <form method="POST" class="row g-3">
        <div class="col-md-6">
            <label>Name</label>
            <input type="text" name="name" class="form-control" value="<?= htmlspecialchars($customer['name']) ?>" required>
        </div>
        <div class="col-md-6">
            <label>Phone</label>
            <input type="text" name="phone" class="form-control" value="<?= htmlspecialchars($customer['phone']) ?>">
        </div>
        <div class="col-md-6">
            <label>Email</label>
            <input type="email" name="email" class="form-control" value="<?= htmlspecialchars($customer['email']) ?>">
        </div>
        <div class="col-md-6">
            <label>Address</label>
            <input type="text" name="address" class="form-control" value="<?= htmlspecialchars($customer['address']) ?>">
        </div>
        <div class="col-md-2 mt-3">
            <button name="update" class="btn btn-primary w-100 mt-2">Update Customer</button>
        </div>
    </form>
</div>

<?php include 'footer.php'; ?>
